/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.utils;

import filenet.pe.peorb.client.ORBServiceHelper;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.util.Base64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class VWSessionManager {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.utils.VWSessionManager");
    protected static final String m_className = "VWSessionManager";
    private static Object obj = new Object();
    private Thread m_monitorThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object = obj;
                    synchronized (object) {
                        obj.wait(30000L);
                        VWSessionManager.this.checkCache();
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    });
    private HashMap<String, PEWSSession> m_sessionList = new HashMap();
    private ArrayList<String> removedKeys = new ArrayList(10);
    private long m_timeOut = 1200000L;
    private boolean noCaching = false;
    private long cacheTimeout = VWSessionManager.getCacheTimeout();
    private long startCaching = System.currentTimeMillis();
    protected static VWSessionManager gInstance = null;
    private static ThreadLocal<String> mySession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache() {
        if (System.currentTimeMillis() - this.startCaching >= this.cacheTimeout) {
            this.cleanupCache(false);
            this.startCaching = System.currentTimeMillis();
            return;
        }
        HashMap<String, PEWSSession> hashMap = this.m_sessionList;
        synchronized (hashMap) {
            Set<String> keySet = this.m_sessionList.keySet();
            if (keySet == null) {
                return;
            }
            for (String theKey : keySet) {
                PEWSSession aPEWSSession = this.m_sessionList.get(theKey);
                if (aPEWSSession != null && aPEWSSession.expired()) {
                    aPEWSSession.releaseVWSession();
                    this.removedKeys.add(theKey);
                }
                aPEWSSession = null;
                theKey = null;
            }
            for (String key : this.removedKeys) {
                this.m_sessionList.remove(key);
            }
            this.removedKeys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupCache(boolean stopThread) {
        if (stopThread) {
            this.m_monitorThread.interrupt();
        }
        HashMap<String, PEWSSession> hashMap = this.m_sessionList;
        synchronized (hashMap) {
            Set<String> keySet = this.m_sessionList.keySet();
            if (keySet == null) {
                return;
            }
            for (String theKey : keySet) {
                PEWSSession aPEWSSession = this.m_sessionList.get(theKey);
                if (aPEWSSession != null) {
                    aPEWSSession.releaseVWSession();
                    this.removedKeys.add(theKey);
                }
                aPEWSSession = null;
                theKey = null;
            }
            for (String key : this.removedKeys) {
                this.m_sessionList.remove(key);
            }
            this.removedKeys.clear();
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "cleanupCache", "invoked");
        }
    }

    protected void _setTimeOut(long timeOut) {
        this.m_timeOut = timeOut;
        if (logger.isFinest()) {
            logger.finest(m_className, "_setTimeOut", Long.toString(timeOut) + " ms.");
        }
        if (timeOut <= 0L) {
            this.disableCaching();
        } else {
            this.noCaching = false;
        }
    }

    private String formKey(String name, String pw, String cpName, String ceURI) {
        if (this.noCaching || name == null || cpName == null || ceURI == null) {
            return null;
        }
        try {
            return Base64.encode(name.getBytes("UTF-8")) + "!#$@**==" + Base64.encode(pw != null ? pw.getBytes("UTF-8") : "_SSO__".getBytes()) + "!#$@**==" + Base64.encode(cpName.getBytes("UTF-8")) + "!#$@**==" + Base64.encode(ceURI.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected static long GetRPC_TIMEOUT(long defaultValue) {
        long res = defaultValue;
        try {
            res = Long.parseLong(JVMSystemConstants.GetPrivilegedSystemProperty("filenet.vw.api.rpc.timeout"));
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "GetRPC_TIMEOUT", Long.toString(res) + "ms");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VWSession _getVWSession(String name, String pw, String cpName, String ceURI, boolean createIt, boolean fromPEWSI, boolean verified) throws VWException {
        HashMap<String, PEWSSession> hashMap;
        String key = this.formKey(name, pw, cpName, ceURI);
        if (key != null) {
            mySession.set(key);
            if (this.m_sessionList.containsKey(key)) {
                try {
                    VWSession ses = null;
                    PEWSSession aPEWSession = this.m_sessionList.get(key);
                    if (aPEWSession != null) {
                        ses = aPEWSession.getVWSession(verified);
                    }
                    if (ses != null) {
                        return ses;
                    }
                    hashMap = this.m_sessionList;
                    synchronized (hashMap) {
                        this.m_sessionList.remove(key);
                    }
                }
                catch (Exception e) {
                    logger.finest(m_className, "_getVWSession", "Ex=" + e.getMessage() + ", Retrying.");
                }
            }
        }
        if (createIt) {
            PEWSSession aSession = null;
            if (fromPEWSI) {
                ORBServiceHelper.LOCAL_TIMEOUT = VWSessionManager.GetRPC_TIMEOUT(10000L);
                aSession = new PEWSSession(null, null, cpName, ceURI, key);
            } else {
                aSession = new PEWSSession(name, pw, cpName, ceURI, key);
            }
            VWSession ses = aSession.getVWSession(false);
            if (ses != null && key != null) {
                hashMap = this.m_sessionList;
                synchronized (hashMap) {
                    this.m_sessionList.put(key, aSession);
                }
            }
            return ses;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _clearSession() {
        String key = mySession.get();
        if (key != null) {
            HashMap<String, PEWSSession> hashMap = this.m_sessionList;
            synchronized (hashMap) {
                this.m_sessionList.remove(key);
            }
        }
    }

    private VWSessionManager() {
        this.m_monitorThread.setName("VWSessionManager.cacheMonitor");
        this.m_monitorThread.start();
    }

    protected void disableCaching() {
        this.noCaching = true;
        if (logger.isFinest()) {
            logger.finest(m_className, "disableCaching", "invoked");
        }
        this.cleanupCache(true);
    }

    public static void setTimeOut(long timeout) {
        timeout = JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("filenet.ws.listener.utils.VWSessionTimeout", timeout);
        gInstance._setTimeOut(timeout);
    }

    private static long getCacheTimeout() {
        return JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("filenet.ws.listener.utils.VWSessionCacheTimeout", 30L) * 60L * 1000L;
    }

    public static VWSession getVWSession(String name, String pw, String cpName) throws VWException {
        return VWSessionManager.getVWSession(name, pw, cpName, null);
    }

    public static VWSession getVWSessionAndVerify(String name, String pw, String cpName, String ceURI) throws VWException {
        return gInstance._getVWSession(name, pw, cpName, ceURI, true, false, true);
    }

    public static VWSession getVWSession(String name, String pw, String cpName, String ceURI) throws VWException {
        return gInstance._getVWSession(name, pw, cpName, ceURI, true, false, false);
    }

    public static VWSession getVWSessionFromCache(String name, String pw, String cpName, String ceURI) throws VWException {
        return gInstance._getVWSession(name, pw, cpName, ceURI, false, false, false);
    }

    public static VWSession getVWSessionInPEWS(String name, String pw, String cpName, String ceURI) throws VWException {
        return gInstance._getVWSession(name, pw, cpName, ceURI, true, true, false);
    }

    public static void releaseResources() {
        gInstance.cleanupCache(true);
    }

    public static void ClearThreadSession() {
        gInstance._clearSession();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10/14/2010 11:14AM  $";
    }

    static {
        gInstance = new VWSessionManager();
        mySession = new ThreadLocal();
    }

    private class PEWSSession {
        private VWSession m_vwSession;
        private long m_timeStamp;
        private String m_id = "[PEWSSession:";

        public PEWSSession(String userName, String password, String cpName, String ceURI, String key) throws VWException {
            StringBuffer buf = new StringBuffer(this.m_id);
            if (userName != null) {
                buf.append(userName);
            }
            buf.append(",").append(cpName).append(",");
            if (key != null) {
                buf.append(key);
            }
            buf.append("]");
            this.m_id = buf.toString();
            this.m_vwSession = new VWSession();
            if (ceURI != null) {
                this.m_vwSession.setBootstrapCEURI(ceURI);
            }
            this.m_vwSession.logon(userName, password, cpName);
            if (logger.isFinest()) {
                logger.finest(VWSessionManager.m_className, this.m_id, "logged on");
            }
            this.touch();
        }

        public VWSession getVWSession(boolean verified) throws VWException {
            if (this.m_vwSession == null) {
                return null;
            }
            String m_method = "getVWSession";
            this.touch();
            if (VWClassFactory.VWSession_verifyCreds(this.m_vwSession, 234L)) {
                if (verified) {
                    this.m_vwSession.fetchQueueNames(1);
                }
            } else {
                logger.finest(VWSessionManager.m_className, "getVWSession", "JAAS Subject expired?");
                this.releaseVWSession();
            }
            return this.m_vwSession;
        }

        public boolean expired() {
            boolean bExpired;
            boolean bl = bExpired = System.currentTimeMillis() - this.m_timeStamp >= VWSessionManager.this.m_timeOut;
            if (bExpired) {
                logger.finest(VWSessionManager.m_className, this.m_id, "expired.");
                this.releaseVWSession();
            }
            return bExpired;
        }

        public void releaseVWSession() {
            try {
                if (this.m_vwSession != null) {
                    logger.finest(VWSessionManager.m_className, this.m_id, "Logging off.");
                    this.m_vwSession.logoff();
                }
                this.m_vwSession = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected void touch() {
            this.m_timeStamp = System.currentTimeMillis();
        }
    }
}

